<?php
    $banner = getContent('banner.content', true);
    $bannerIcon = getContent('banner_icon.content', true);
?>
<section class="banner-section">
    <div class="banner-section-bg-img">
        <img src="<?php echo e(asset($activeTemplateTrue . 'images/banner-bg.png')); ?>" alt="image">
    </div>
    <div class="banner-ac-imgs animated">
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->one, '35x35')); ?>" alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->two, '35x35')); ?>" alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->three, '35x35')); ?>"
                alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->four, '35x35')); ?>""
                alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->five, '35x35')); ?>"
                alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->six, '35x35')); ?>" alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->seven, '35x35')); ?>"
                alt="image"></span>
        <span class="ac-img animated"><img
                src="<?php echo e(frontendImage('banner_icon', @$bannerIcon->data_values->eight, '35x35')); ?>"
                alt="image"></span>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-8">
                <div class="banner-content text-center">
                    <h1 class="banner-content__title"><?php echo e(__(@$banner->data_values->heading)); ?></h1>
                    <p class="banner-content__desc"><?php echo e(__(@$banner->data_values->description)); ?></p>
                    <ul class="banner-category-list">
                        <?php $__currentLoopData = $categories->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="item">
                                <a href="<?php echo e(route('category.products', ['slug' => slug($category->name), 'id' => $category->id])); ?>"
                                    class="link"><?php echo e(__($category->name)); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                    <div class="banner-content__buttons flex-center">
                        <a href="<?php echo e(@$banner->data_values->first_button_url); ?>" class="btn btn--base">
                            <?php echo e(__(@$banner->data_values->first_button_name)); ?>

                        </a>
                        <a href="<?php echo e(@$banner->data_values->second_button_url); ?>" class="btn btn-outline--base">
                            <?php echo e(__(@$banner->data_values->second_button_name)); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>