<?php
    $about = getContent('about.content', true);
    $aboutElement = getContent('about.element', orderById: true);
?>
<section class="about-us py-120">
    <div class="container">
        <div class="row gy-4 align-items-center flex-wrap-reverse">
            <div class="col-lg-6 col-md-10 ">
                <div class="about-us__thumb">
                    <img src="<?php echo e(frontendImage('about', @$about->data_values->image, '465x400')); ?>"
                        alt="<?php echo app('translator')->get('image'); ?>">
                </div>
            </div>
            <div class="col-lg-6 pe-xl-5">
                <div class="about-content">
                    <div class="section-heading style-left">
                        <span class="section-heading__subtitle"><?php echo e(__(@$about->data_values->heading)); ?></span>
                        <h2 class="section-heading__title"><?php echo e(__(@$about->data_values->subheading)); ?></h2>
                        <p class="section-heading__desc">
                            <?php
                                echo @$about->data_values->description;
                            ?>
                        </p>
                    </div>
                    <ul class="text-list">
                        <?php $__currentLoopData = $aboutElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-list__item flex-wrap">
                                <span class="icon"> <i class="fas fa-check-circle"></i> </span>
                                <span class="text fs-15"><?php echo e(__(@$item->data_values->title)); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/sections/about.blade.php ENDPATH**/ ?>