<?php $__env->startSection('content'); ?>
    <?php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $register = getContent('register.content', true);
    ?>
    <?php if(gs('registration')): ?>
        <section class="account">
            <div class="account-inner">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8 col-lg-7 col-xl-6">
                            <div class="account-form">
                                <div class="account-form__content mb-4">
                                    <h3 class="account-form__title mb-2"><?php echo e(__(@$register->data_values->heading)); ?></h3>
                                    <p class="account-form__desc"> <?php echo e(__(@$register->data_values->subheading)); ?> </p>
                                    <?php echo $__env->make($activeTemplate . 'partials.social_login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <form action="<?php echo e(route('user.register')); ?>" method="POST"
                                    class="verify-gcaptcha disableSubmission">
                                    <?php echo csrf_field(); ?>

                                    <div class="row">
                                        <?php if(session()->get('reference') != null): ?>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="referenceBy" class="form--label"><?php echo app('translator')->get('Reference by'); ?></label>
                                                    <input type="text" name="referBy" id="referenceBy"
                                                        class="form--control" value="<?php echo e(session()->get('reference')); ?>"
                                                        readonly>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('First Name'); ?></label>
                                                <input type="text" class="form--control" name="firstname"
                                                    value="<?php echo e(old('firstname')); ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Last Name'); ?></label>
                                                <input type="text" class="form--control" name="lastname"
                                                    value="<?php echo e(old('lastname')); ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('E-Mail Address'); ?></label>
                                                <input type="email" class="form--control checkUser" name="email"
                                                    value="<?php echo e(old('email')); ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Password'); ?></label>
                                                <input type="password"
                                                    class="form--control  <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                                                    name="password" required>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                                <input type="password" class="form--control" name="password_confirmation"
                                                    required>
                                            </div>
                                        </div>

                                        <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                                    </div>

                                    <?php if(gs('agree')): ?>
                                        <div class="form-group">
                                            <input type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?>
                                                name="agree" required>
                                            <label for="agree"><?php echo app('translator')->get('I agree with'); ?></label> <span>
                                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>" class="text--base">
                                                        <?php echo e(__($policy->data_values->title)); ?>

                                                    </a>
                                                    <?php if(!$loop->last): ?>
                                                        ,
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="form-group">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100">
                                            <?php echo app('translator')->get('Register'); ?></button>
                                    </div>
                                    <p class="mb-0 text-center"><?php echo app('translator')->get('Already have an account?'); ?>
                                        <a href="<?php echo e(route('user.login')); ?>"
                                            class="have-account__link text--base"><?php echo app('translator')->get('Login'); ?></a>
                                    </p>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php else: ?>
        <?php echo $__env->make($activeTemplate . 'partials.registration_disabled', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title method-name"><?php echo app('translator')->get('You are with us'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo app('translator')->get('You already have an account please Login'); ?></p>
                </div>
                <div class="modal-footer">
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn-sm btn--base w-100"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .social-login-btn {
            border: 1px solid #cbc4c4;
        }

        .register-disable {
            height: 100vh;
            width: 100%;
            background-color: #fff;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-disable-image {
            max-width: 300px;
            width: 100%;
            margin: 0 auto 32px;
        }

        .register-disable-title {
            color: rgb(0 0 0 / 80%);
            font-size: 42px;
            margin-bottom: 18px;
            text-align: center
        }

        .register-disable-icon {
            font-size: 16px;
            background: rgb(255, 15, 15, .07);
            color: rgb(255, 15, 15, .8);
            border-radius: 3px;
            padding: 6px;
            margin-right: 4px;
        }

        .register-disable-desc {
            color: rgb(0 0 0 / 50%);
            font-size: 18px;
            max-width: 565px;
            width: 100%;
            margin: 0 auto 32px;
            text-align: center;
        }

        .register-disable-footer-link {
            color: #fff;
            background-color: #5B28FF;
            padding: 13px 24px;
            border-radius: 6px;
            text-decoration: none
        }

        .register-disable-footer-link:hover {
            background-color: #440ef4;
            color: #fff;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php if(gs('secure_password')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';

                var data = {
                    email: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $('#existModalCenter').modal('show');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chrislog/public_html/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>