<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card custom--card">
            <div class="card-header">
                <h5 class="card-title text-center"><?php echo app('translator')->get('Fund Wallet'); ?></h5>
            </div>
            <div class="card-body">
                <form class="register" id="paymentForm" action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="form-group col-sm-12">
                            <label class="form--label"><?php echo app('translator')->get('Enter amount'); ?></label>
                            <input type="number" class="form--control amount" name="amount" value="<?php echo e(old('amount')); ?>" >
                        </div>

                        <div class="form-group col-sm-12">
                            <label class="form--label">Select payment method</label>

                            <select class="form-control mb-3 paymentMethod" name="method">
                              <option disabled selected>Select Method</option>

                              <?php if($isPaystackGatewayEnabled): ?>
                                    <option value="paystack">Paystack</option>
                              <?php endif; ?>

                              
                            </select>
                          </div>

                        <div class="form-group text-center">
                            <button type="submit" id="btn-confirm" class="btn  btn--base w-50"><?php echo app('translator')->get('Pay now'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
<script src="//js.paystack.co/v1/inline.js"></script>

<script>
$(document).ready(function() {
    $('#btn-confirm').on('click', function(e) {
        e.preventDefault();

        const paymentMethod = $('.paymentMethod').val();
        const amount = $('.amount').val();

        console.log(paymentMethod);

        switch (paymentMethod) {
            case 'paystack':
                // Initialize Paystack payment modal
                let handler = PaystackPop.setup({
                    key: "<?php echo e($paystackDetails['gatewayParameter']?->public_key?->value ?? ''); ?>",
                    email: "<?php echo e($user->email); ?>",
                    amount: amount * 100,
                    onClose: function(){
                        alert('Window closed.');
                    },
                    callback: function(response){

                        window.location.href = "<?php echo e(route('user.paystack-payment.callback')); ?>?reference=" + response.reference;
                    }
                });
                handler.openIframe();
                break;

                case '1000':

                window.location.href = "<?php echo e(route('user.fund-wallet.manual')); ?>?am=" + amount + "&mt=" + paymentMethod;


            default:
                // alert('Invalid payment method selected.');
                // break;
        }
    });
});

</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chrislog/public_html/core/resources/views/templates/basic/user/fund_wallet.blade.php ENDPATH**/ ?>