<div class="top-header d-none d-lg-block">
    <div class="container">
        <div class="top-header__inner flex-between">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('image'); ?>">
            </a>
            <div class="search-box style-two w-100">
                <form class="search-form">
                    <input type="text" class="form--control pill" name="search" placeholder="<?php echo app('translator')->get('Search...'); ?>"
                        <?php if(request()->routeIs('products') || request()->routeIs('category.products')): ?> value="<?php echo e(request()->search); ?>" <?php endif; ?>>
                    <button type="submit" class="search-box__button">
                        <span class="icon"><i class="las la-search"></i></span>
                    </button>
                </form>
            </div>
            <div class="account-buttons flex-align gap-3">

                <?php if(gs('multi_language')): ?>
                    <?php
                        $language = App\Models\Language::all();
                    ?>
                    <div class="custom--dropdown">
                        <?php if(session('lang')): ?>
                            <div class="custom--dropdown__selected dropdown-list__item">
                                <div class="thumb">
                                    <img class="flag" alt="image"
                                        src="<?php echo e(getImage(getFilePath('language') . '/' . @$language->where('code', session('lang'))->first()->image, getFileSize('language'))); ?>">
                                </div>
                                <span class="text"><?php echo e(strtoupper(session('lang'))); ?></span>
                            </div>
                        <?php else: ?>
                            <?php $default = $language->where('is_default',Status::YES)->first() ?>
                            <div class="custom--dropdown__selected dropdown-list__item">
                                <div class="thumb">
                                    <img class="flag" alt="image"
                                        src="<?php echo e(getImage(getFilePath('language') . '/' . @$default->image, getFileSize('language'))); ?>">
                                </div>
                                <span class="text"><?php echo e(strtoupper(@$default->code)); ?></span>
                            </div>
                        <?php endif; ?>
                        <ul class="dropdown-list">
                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="dropdown-list__item langSel"
                                    data-url="<?php echo e(route('home')); ?>/change/<?php echo e($item->code); ?>">
                                    <div class="thumb">
                                        <img class="flag" alt="image"
                                            src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image, getFileSize('language'))); ?>"
                                            loading="lazy">
                                    </div>
                                    <span class="text"><?php echo e(strtoupper($item->code)); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('user.logout')); ?>" class="btn--account">
                        <span class="icon fs-14 me-1"><i class="fas fa-sign-out-alt"></i></span> <?php echo app('translator')->get('Logout'); ?>
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn--account">
                        <span class="icon fs-14 me-1"><i class="fas fa-sign-in-alt"></i></span> <?php echo app('translator')->get('Login'); ?>
                    </a>
                <?php endif; ?>

                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('user.home')); ?>" class="btn btn--base btn--md">
                        <span class="icon fs-14 me-1"><i class="fas fa-home"></i></span> <?php echo app('translator')->get('Dashboard'); ?>
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('user.register')); ?>" class="btn btn--base btn--md">
                        <span class="icon fs-14 me-1"><i class="fas fa-user-plus"></i></span> <?php echo app('translator')->get('Register'); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.search-form').on('submit', function(e) {
                e.preventDefault();
                var keyword = $(this).find('input[name=search]').val();
                window.location.href = "<?php echo e(route('products')); ?>?search=" + keyword;
            })
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/partials/header_top.blade.php ENDPATH**/ ?>