<?php $__env->startSection('content'); ?>
    <div class="row justify-content-end mb-4">
        <div class="col-xl-4 col-md-6">
            <form>
                <div class="input-group">
                    <input type="search" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>"
                        placeholder="<?php echo app('translator')->get('Search by Trx'); ?>">
                    <button class="input-group-text bg--base border-0 text--white">
                        <i class="las la-search"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="table-responsive">
                <table class="table table--responsive--lg custom--table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Gateway | Trx'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Conversion'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="td-wrapper">
                                        <span class="fw-bold">
                                            <span class="text-primary">
                                                <?php if($deposit->method_code < 5000): ?>
                                                    <?php echo e(__(@$deposit->gateway->name)); ?>

                                                <?php else: ?>
                                                    <?php echo app('translator')->get('Google Pay'); ?>
                                                <?php endif; ?>
                                            </span>
                                        </span>
                                        <br>
                                        <small> <?php echo e($deposit->trx); ?> </small>
                                    </div>
                                </td>

                                <td>
                                    <div class="td-wrapper">
                                        <span class="d-block"><?php echo e(showDateTime($deposit->created_at)); ?></span>
                                        <span class=""><?php echo e(diffForHumans($deposit->created_at)); ?></span>
                                    </div>

                                </td>
                                <td>
                                    <div class="td-wrapper">
                                        <span class="">
                                            <?php echo e(showAmount($deposit->amount)); ?> + <span class="text--danger"
                                                data-bs-toggle="tooltip"
                                                title="<?php echo app('translator')->get('Processing Charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?> </span>
                                        </span>
                                        <strong class="d-block" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                            <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?>

                                        </strong>
                                    </div>
                                </td>
                                <td>
                                    <div class="td-wrapper">
                                        <span>
                                            <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($deposit->rate, currencyFormat: false)); ?>

                                            <?php echo e(__($deposit->method_currency)); ?>

                                        </span>
                                        <strong class="d-block">
                                            <?php echo e(showAmount($deposit->final_amount, currencyFormat: false)); ?>

                                            <?php echo e(__($deposit->method_currency)); ?>

                                        </strong>
                                    </div>
                                </td>
                                <td>
                                    <?php echo $deposit->statusBadge ?>
                                </td>
                                <?php
                                    $details = [];
                                    if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                        foreach (@$deposit->detail ?? [] as $key => $info) {
                                            $details[] = $info;
                                            if ($info->type == 'file') {
                                                $details[$key]->value = route(
                                                    'user.download.attachment',
                                                    encrypt(getFilePath('verify') . '/' . $info->value),
                                                );
                                            }
                                        }
                                    }
                                ?>
                                <td>
                                    <div class="action-buttons">
                                        <?php if(@$deposit->order->status == Status::ORDER_PAID): ?>
                                        
                                        
                                          <a href="<?php echo e(route('user.orders', ['search' => $deposit->trx])); ?>"
                                                title="<?php echo app('translator')->get('Order Details'); ?>"
                                        <button class="btn btn--dark btn--sm">Order Details</button>
                                            </a>
                                        <?php else: ?>
                                            <button class="action-btn btn btn--dark btn--sm" disabled
                                                title="<?php echo app('translator')->get('Order Details'); ?>">
                                        <button class="btn btn--dark btn--sm"></i>
                                            </button>
                                     
                                            
                                        <?php endif; ?>

                                        <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                            <a href="javascript:void(0)" class="action-btn btn btn--base btn--sm detailBtn"
                                                data-info="<?php echo e(json_encode($details)); ?>"
                                                <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                                <i class="fas fa-desktop"></i>
                                            </a>
                                        <?php else: ?>
                                            <button type="button" class="action-btn btn btn--success btn--sm"
                                                data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Automatically processed'); ?>">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php echo e(paginateLinks($deposits)); ?>

    </div>

    
    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title"><?php echo app('translator')->get('Details'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush userData">
                    </ul>
                    <div class="feedback"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        } else {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span"><a href="${element.value}"><i class="fa-regular fa-file"></i> <?php echo app('translator')->get('Attachment'); ?></a></span>
                            </li>`;
                        }
                    });
                }

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3 ms-2">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                if (!html && !adminFeedback) {
                    html = `<span class='d-block text-center mt-2 mb-2'><?php echo e(__($emptyMessage)); ?></span>`;
                }

                modal.find('.userData').html(html);
                modal.find('.feedback').html(adminFeedback);
                modal.modal('show');
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title], [data-title], [data-bs-title]'))
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/user/deposit_history.blade.php ENDPATH**/ ?>