<?php
    $footerContent = getContent('footer.content', true);
    $policyPages = getContent('policy_pages.element', orderById: true);
    $socials = getContent('social_icon.element', orderById: true);
    $contact = getContent('contact_us.content', true);
?>
<footer class="footer-area">
    <div class="pb-60 pt-120">
        <div class="container">
            <div class="row justify-content-center gy-5">
                <div class="col-xl-4 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <div class="footer-item__logo">
                            <a href="<?php echo e(route('home')); ?>"> <img src="<?php echo e(siteLogo('dark')); ?>" alt="<?php echo app('translator')->get('image'); ?>"></a>
                        </div>
                        <p class="footer-item__desc"><?php echo e(__(@$footerContent->data_values->description)); ?></p>
                        <ul class="social-list">
                            <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="social-list__item">
                                    <a href="<?php echo e(@$social->data_values->url); ?>" class="social-list__link flex-center"
                                        target="_blank">
                                        <?php echo $social->data_values->social_icon ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Useful Links'); ?></h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item"><a href="<?php echo e(route('products')); ?>"
                                    class="footer-menu__link"><?php echo app('translator')->get('Product'); ?></a></li>
                            <?php if(auth()->guard()->check()): ?>
                                <li class="footer-menu__item"><a href="<?php echo e(route('user.logout')); ?>"
                                        class="footer-menu__link"><?php echo app('translator')->get('Logout'); ?></a></li>
                            <?php else: ?>
                                <li class="footer-menu__item"><a href="<?php echo e(route('user.login')); ?>"
                                        class="footer-menu__link"><?php echo app('translator')->get('Login'); ?></a></li>
                                <li class="footer-menu__item"><a href="<?php echo e(route('user.register')); ?>"
                                        class="footer-menu__link"><?php echo app('translator')->get('Register'); ?> </a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Resources'); ?></h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item"><a href="<?php echo e(route('blog')); ?>"
                                    class="footer-menu__link"><?php echo app('translator')->get('Blog'); ?> </a></li>
                            <li class="footer-menu__item"><a href="<?php echo e(route('contact')); ?>"
                                    class="footer-menu__link"><?php echo app('translator')->get('Contact Us'); ?> </a></li>
                            <li class="footer-menu__item"><a href="<?php echo e(route('cookie.policy')); ?>"
                                    class="footer-menu__link"><?php echo app('translator')->get('Cookie Policy'); ?> </a></li>

                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Contact Us'); ?></h5>
                        <ul class="footer-contact-menu">
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p><?php echo e(__(@$contact->data_values->contact_details)); ?></p>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p>
                                        <a class="text--white"
                                            href="mailto:<?php echo e(@$contact->data_values->email_address); ?>"><?php echo e(@$contact->data_values->email_address); ?></a>
                                    </p>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p><a class="text--white"
                                            href="tel:<?php echo e(@$contact->data_values->contact_number); ?>"><?php echo e(@$contact->data_values->contact_number); ?></a>
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3">
                <div class="col-sm-6">
                    <div class="bottom-footer__text"> &copy; <?php echo app('translator')->get('Copyright'); ?> <?php echo date('Y') ?> . <?php echo app('translator')->get('All rights reserved'); ?>.
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="bottom-footer__menu d-flex align-items-end justify-content-end">
                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>" class="bottom-footer__link">
                                <?php echo e(__(@$policy->data_values->title)); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>