<?php
    $blogContent = getContent('blog.content', true);
    $blogs = getContent('blog.element', null, 3, false);
?>
<section class="blog py-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="section-heading">
                    <span class="section-heading__subtitle"><?php echo e(__(@$blogContent->data_values->heading)); ?></span>
                    <h2 class="section-heading__title"><?php echo e(__(@$blogContent->data_values->subheading)); ?></h2>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="blog-item">
                        <div class="blog-item__thumb">
                            <img src="<?php echo e(frontendImage('blog', @$blog->data_values->image, '410x275', thumb: true)); ?>"
                                alt="<?php echo app('translator')->get('image'); ?>">
                        </div>
                        <div class="blog-item__content">
                            <span class="blog-item__meta"><i
                                    class="las la-calendar-week"></i><?php echo e($blog->created_at->format('d M, Y')); ?></span>
                            <h4 class="blog-item__title">
                                <a class="blog-item__title-link"
                                    href="<?php echo e(route('blog.details', [slug($blog->data_values->title), $blog->id])); ?>"><?php echo e(__(@$blog->data_values->title)); ?></a>
                            </h4>
                            <p class="blog-item__desc">
                                <?php
                                    echo strLimit(strip_tags($blog->data_values->description), 40);
                                ?>
                            </p>
                            <a href="<?php echo e(route('blog.details', [slug($blog->data_values->title), $blog->id])); ?>"
                                class="blog-item__link"><?php echo app('translator')->get('Read More'); ?> <i class="las la-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/chrislog/public_html/core/resources/views/templates/basic/sections/blog.blade.php ENDPATH**/ ?>